﻿using System;

namespace Microscopic_Traffic_Simulator
{
    /// <summary>
    /// Extended relay command class by adding event after executing command. Useful for performing
    /// additional UI task after the action of command is finished.
    /// </summary>
    class ObservableRelayCommand : RelayCommand
    {
        /// <summary>
        /// Creates a new observable command that can always execute.
        /// </summary>
        /// <param name="execute">The execution logic.</param>
        public ObservableRelayCommand(Action<object> execute) : base(execute) { }

        /// <summary>
        /// Creates a new observable command.
        /// </summary>
        /// <param name="execute">The execution logic.</param>
        /// <param name="canExecute">The execution status logic.</param>
        public ObservableRelayCommand(Action<object> execute, Predicate<object> canExecute)
            : base(execute, canExecute) { }

        /// <summary>
        /// Event handler of events executing after finishing command action
        /// </summary>
        public event EventHandler CommandExecuted = delegate { };

        /// <summary>
        /// Execute action and then fire CommandExecuted event.
        /// </summary>
        /// <param name="parameter">Parameter of action</param>
        public override void Execute(object parameter)
        {
            base.Execute(parameter);
            if (CommandExecuted != null)
                CommandExecuted(this, EventArgs.Empty);
        }
    }
}
